//
//  BPURLUploader.h
//  FileDownloader
//
//  Created by Alykhan Jetha on 10-05-06.
//  Copyright 2010 Marketcircle, Inc. All rights reserved.
//

#import "BPURLMessage.h"

/*!
 Instead of using the classic post form method of file upload, we wrap the file contents in an XML document. This system is designed for *small* files. It is not designed for the likes of a 10MB file.
 
 We use an XML document because we don't want to get into the MIME parsing business on the server.
 */
@interface BPURLUploader : BPURLMessage {
	NSURL *sourceFile;
	NSData *sourceData;
	NSDictionary *attributes;
	NSXMLDocument *xml;
	
	NSUInteger bytesSent;
	NSUInteger totalBytes;
	
}

@property (retain) NSData *sourceData;
@property (retain) NSURL *sourceFile;
@property (retain) NSDictionary *attributes;
@property (retain) NSXMLDocument *xml;

@property (assign) NSUInteger bytesSent;
@property (assign) NSUInteger totalBytes;


- (id)initForURL:(NSString *)aURLStr 
	 localSource:(NSString *)local 
			data:(NSData *)someData 
	  attributes:(NSDictionary *)attribs 
		username:(NSString *)aUsername 
		password:(NSString *)aPassword 
		delegate:(id)aDeleg;


@end

@interface NSObject (BPURLUploaderDelegate)
- (void)uploaderDidFinish:(BPURLUploader *)anUploader;
@end
